all_genes = read.csv("~/cac/final/dataframe/gene_master.csv")
yeast_gene = subset(all_genes,chr!='chrM' & all_genes$overlap==F)
f_col=brewer.pal(6,"Blues")
n = nrow(yeast_gene)

cac_sense_rep1 = read.csv('~/data/cac_sense_rep1.csv')
wt_sense_rep1 = read.csv('~/data/wt_sense_rep1.csv')

cac_sense_rep2 = read.csv('~/data/cac_sense_rep2.csv')
wt_sense_rep2 = read.csv('~/data/wt_sense_rep2.csv')

cac_AS_rep1 = read.csv('~/data/cac_AS_rep1.csv')
wt_AS_rep1 = read.csv('~/data/wt_AS_rep1.csv')

cac_AS_rep2 = read.csv('~/data/cac_AS_rep2.csv')
wt_AS_rep2 = read.csv('~/data/wt_AS_rep2.csv')



#plot replicate 1 (8 time points) alone, figure5B-E
#get log2 fold change 
sense_ratio_rep1 = data.frame("af"=rep(0,n),"s10"=rep(0,n),"s20"=rep(0,n),"s30"=rep(0,n),
                              "s40"=rep(0,n),"s50"=rep(0,n),"s60"=rep(0,n),"s150"=rep(0,n),
                              gene = yeast_gene$gene,subtelomeric = yeast_gene$subtelomeric)
for (i in 1:8) {
  sense_ratio_rep1 [,i] = log2( (cac_sense_rep1[,i+1] +0.001)/(wt_sense_rep1[,i+1] +0.001))
}

AS_ratio_rep1 = data.frame("af"=rep(0,n),"s10"=rep(0,n),"s20"=rep(0,n),"s30"=rep(0,n),
                              "s40"=rep(0,n),"s50"=rep(0,n),"s60"=rep(0,n),"s150"=rep(0,n),
                              gene = yeast_gene$gene,subtelomeric = yeast_gene$subtelomeric)
for (i in 1:8) {
  AS_ratio_rep1 [,i] = log2( (cac_AS_rep1[,i+1] +0.001)/(wt_AS_rep1[,i+1] +0.001))
}

tel_sense_ratio_rep1 = subset(sense_ratio_rep1,subtelomeric ==T)
nontel_sense_ratio_rep1 = subset(sense_ratio_rep1,subtelomeric ==F)
tel_AS_ratio_rep1 = subset(AS_ratio_rep1,subtelomeric ==T)
nontel_AS_ratio_rep1 = subset(AS_ratio_rep1,subtelomeric ==F)

#plotting
scr.m = matrix(c(0.1, 0.5, 0.54, 0.95,
                 0.5, 0.9, 0.54, 0.95, 
                 
                 0.1, 0.5, 0.1, 0.51,
                 0.5, 0.9, 0.1, 0.51 

),
ncol = 4, byrow = T
)


file.name <- "/data/figure/figure5/figure5_txn_boxplot.png"
png(file = file.name, width = 11, height = 8, units = "in", res = 250, bg = "white", type = "cairo-png" )
par(cex=1.5)

close.screen(all.screens = T)

split.screen(scr.m)

par(oma = c(0, 0, 0, 0)) # make room (i.e. the 4's) for the overall x and y axis titles

screen(1)
par(mar = c(2,2,2,1), cex=1, cex.main=1.2) 
boxplot(tel_sense_ratio_rep1[,'af'],tel_sense_ratio_rep1[,'s10'],tel_sense_ratio_rep1[,'s20'],tel_sense_ratio_rep1[,'s30'],
        tel_sense_ratio_rep1[,'s40'],tel_sense_ratio_rep1[,'s50'],tel_sense_ratio_rep1[,'s60'],tel_sense_ratio_rep1[,'s150'],
        ylim=c(-2, 5),
        main="Subtelomeric genes",outline=F, notch=T,
        names = c("af","10","20","30","40","50","60","150"),
        col=f_col[4])


screen(2)
par(mar = c(2,2,2,1), cex=1, cex.main=1.2) 
boxplot(nontel_sense_ratio_rep1[,'af'],nontel_sense_ratio_rep1[,'s10'],nontel_sense_ratio_rep1[,'s20'],nontel_sense_ratio_rep1[,'s30'],
        nontel_sense_ratio_rep1[,'s40'],nontel_sense_ratio_rep1[,'s50'],nontel_sense_ratio_rep1[,'s60'],nontel_sense_ratio_rep1[,'s150'],
        ylim=c(-2, 5),
        main="Non-subtelomeric genes",outline=F, notch=T,
        names = c("af","10","20","30","40","50","60","150"),
        col=f_col[4])

screen(3)
par(mar = c(2,2,2,1), cex=1, cex.main=0.7) 
boxplot(tel_AS_ratio_rep1[,'af'],tel_AS_ratio_rep1[,'s10'],tel_AS_ratio_rep1[,'s20'],tel_AS_ratio_rep1[,'s30'],
        tel_AS_ratio_rep1[,'s40'],tel_AS_ratio_rep1[,'s50'],tel_AS_ratio_rep1[,'s60'],tel_AS_ratio_rep1[,'s150'],
        ylim=c(-5, 8),
        main="",outline=F, notch=T,
        names = c("af","10","20","30","40","50","60","150"),
        col=f_col[4])

screen(4)
par(mar = c(2,2,2,1), cex=1, cex.main=0.7) 
boxplot(nontel_AS_ratio_rep1[,'af'],nontel_AS_ratio_rep1[,'s10'],nontel_AS_ratio_rep1[,'s20'],nontel_AS_ratio_rep1[,'s30'],
        nontel_AS_ratio_rep1[,'s40'],nontel_AS_ratio_rep1[,'s50'],nontel_AS_ratio_rep1[,'s60'],nontel_AS_ratio_rep1[,'s150'],
        ylim=c(-5, 8),
        main="",outline=F, notch=T,
        names = c("af","10","20","30","40","50","60","150"),
        col=f_col[4])

close.screen(all.screens = T)

dev.off()



#processing replicate 
sense_ratio_rep2 = data.frame("af"=rep(0,n),"s40"=rep(0,n),"s60"=rep(0,n),
                              gene = yeast_gene$gene,subtelomeric = yeast_gene$subtelomeric)
for (i in 1:3) {
  sense_ratio_rep2 [,i] = log2( (cac_sense_rep2[,i+1] +0.001)/(wt_sense_rep2[,i+1] +0.001))
}

AS_ratio_rep2 = data.frame("af"=rep(0,n),"s40"=rep(0,n),"s60"=rep(0,n),
                              gene = yeast_gene$gene,subtelomeric = yeast_gene$subtelomeric)
for (i in 1:3) {
  AS_ratio_rep2 [,i] = log2( (cac_AS_rep2[,i+1] +0.001)/(wt_AS_rep2[,i+1] +0.001))
}
tel_sense_ratio_rep2 = subset(sense_ratio_rep2,subtelomeric ==T)
nontel_sense_ratio_rep2 = subset(sense_ratio_rep2,subtelomeric ==F)
tel_AS_ratio_rep2 = subset(AS_ratio_rep2,subtelomeric ==T)
nontel_AS_ratio_rep2 = subset(AS_ratio_rep2,subtelomeric ==F)

scr.m = matrix(c(0.1, 0.5, 0.54, 0.95,
                 0.5, 0.9, 0.54, 0.95, 
                 
                 0.1, 0.5, 0.1, 0.51,
                 0.5, 0.9, 0.1, 0.51 
                 
),
ncol = 4, byrow = T
)

#version1 all time points from both replicates 
#######
file.name <- "/data/figure/supple14_txn_boxplot.png"
png(file = file.name, width = 11, height = 8, units = "in", res = 250, bg = "white", type = "cairo-png" )
par(cex=1.5)

close.screen(all.screens = T)

split.screen(scr.m)

par(oma = c(0, 0, 0, 0)) # make room (i.e. the 4's) for the overall x and y axis titles

screen(1)
par(mar = c(2,2,2,1), cex=1, cex.main=1) 
boxplot(tel_sense_ratio_rep1[,'af'],tel_sense_ratio_rep2[,'af'],
        tel_sense_ratio_rep1[,'s10'],tel_sense_ratio_rep1[,'s20'],tel_sense_ratio_rep1[,'s30'],
        tel_sense_ratio_rep1[,'s40'],tel_sense_ratio_rep2[,'s40'],
        tel_sense_ratio_rep1[,'s50'],
        tel_sense_ratio_rep1[,'s60'],tel_sense_ratio_rep2[,'s60'],
        tel_sense_ratio_rep1[,'s150'],
        at = c(1,2,3,5,7,9,10,11,13,14,15),
        ylim=c(-2, 5),
        main="Subtelomeric genes",outline=F, notch=T,xaxt='n',
        col=c(f_col[3],f_col[5],rep(f_col[3],4),f_col[5],f_col[3],f_col[3],f_col[5],f_col[3]))
for (k in seq(2.5,14.5,2)) {
  abline(v=k,lty=2,col='grey60')
}
axis(side =1,at=c(1.5,3.5,5.5,7.5,9.5,11.5,13.5,15.5),labels = c('af',10,20,30,40,50,60,150) )
legend('topleft',c('Rep1','Rep2'),col=c(f_col[3],f_col[5]),pch=c(20,20),bty="n")

screen(2)
par(mar = c(2,2,2,1), cex=1, cex.main=1) 
boxplot(nontel_sense_ratio_rep1[,'af'],nontel_sense_ratio_rep1[,'af'],
        nontel_sense_ratio_rep1[,'s10'],nontel_sense_ratio_rep1[,'s20'],nontel_sense_ratio_rep1[,'s30'],
        nontel_sense_ratio_rep1[,'s40'],nontel_sense_ratio_rep1[,'s40'],
        nontel_sense_ratio_rep1[,'s50'],
        nontel_sense_ratio_rep1[,'s60'],nontel_sense_ratio_rep1[,'s60'],
        nontel_sense_ratio_rep1[,'s150'],
        at = c(1,2,3,5,7,9,10,11,13,14,15),
        ylim=c(-2, 5),
        main="Non-subtelomeric genes",outline=F, notch=T,xaxt='n',
        col=c(f_col[3],f_col[5],rep(f_col[3],4),f_col[5],f_col[3],f_col[3],f_col[5],f_col[3]))
for (k in seq(2.5,14.5,2)) {
  abline(v=k,lty=2,col='grey60')
}
axis(side =1,at=c(1.5,3.5,5.5,7.5,9.5,11.5,13.5,15.5),labels = c('af',10,20,30,40,50,60,150) )
legend('topleft',c('Rep1','Rep2'),col=c(f_col[3],f_col[5]),pch=c(20,20),bty="n")


screen(3)
par(mar = c(2,2,2,1), cex=1, cex.main=1) 
boxplot(tel_AS_ratio_rep1[,'af'],tel_AS_ratio_rep1[,'af'],
        tel_AS_ratio_rep1[,'s10'],tel_AS_ratio_rep1[,'s20'],tel_AS_ratio_rep1[,'s30'],
        tel_AS_ratio_rep1[,'s40'],tel_AS_ratio_rep1[,'s40'],
        tel_AS_ratio_rep1[,'s50'],
        tel_AS_ratio_rep1[,'s60'],tel_AS_ratio_rep1[,'s60'],
        tel_AS_ratio_rep1[,'s150'],
        at = c(1,2,3,5,7,9,10,11,13,14,15),
        ylim=c(-5, 10),
        main="",outline=F, notch=T,xaxt='n',
        col=c(f_col[3],f_col[5],rep(f_col[3],4),f_col[5],f_col[3],f_col[3],f_col[5],f_col[3]))
for (k in seq(2.5,14.5,2)) {
  abline(v=k,lty=2,col='grey60')
}
axis(side =1,at=c(1.5,3.5,5.5,7.5,9.5,11.5,13.5,15.5),labels = c('af',10,20,30,40,50,60,150) )
legend('topleft',c('Rep1','Rep2'),col=c(f_col[3],f_col[5]),pch=c(20,20),bty="n")

screen(4)
par(mar = c(2,2,2,1), cex=1, cex.main=1) 
boxplot(nontel_AS_ratio_rep1[,'af'],nontel_AS_ratio_rep1[,'af'],
        nontel_AS_ratio_rep1[,'s10'],nontel_AS_ratio_rep1[,'s20'],nontel_AS_ratio_rep1[,'s30'],
        nontel_AS_ratio_rep1[,'s40'],nontel_AS_ratio_rep1[,'s40'],
        nontel_AS_ratio_rep1[,'s50'],
        nontel_AS_ratio_rep1[,'s60'],nontel_AS_ratio_rep1[,'s60'],
        nontel_AS_ratio_rep1[,'s150'],
        at = c(1,2,3,5,7,9,10,11,13,14,15),
        ylim=c(-5, 10),
        main="",outline=F, notch=T,xaxt='n',
        col=c(f_col[3],f_col[5],rep(f_col[3],4),f_col[5],f_col[3],f_col[3],f_col[5],f_col[3]))
for (k in seq(2.5,14.5,2)) {
  abline(v=k,lty=2,col='grey60')
}
axis(side =1,at=c(1.5,3.5,5.5,7.5,9.5,11.5,13.5,15.5),labels = c('af',10,20,30,40,50,60,150) )
legend('topleft',c('Rep1','Rep2'),col=c(f_col[3],f_col[5]),pch=c(20,20),bty="n")

close.screen(all.screens = T)

dev.off()

######



